/*
 * CardList.cpp
 *
 *  Created on: Jan 5, 2012
 *      Author: ts
 */

#include "CardList.h"

CardList::CardList(int owner) {
   this->owner = owner;
   this->head = 0;
   this->tail = 0;
}  //constructor CardList

CardList::~CardList() {
   DeleteCards(this->head);
}

// function to read in the unshuffled deck from a text file
int CardList::ReadRawDeck(string filename) {
   ifstream infile;
   char readline[40];
   int line_count = 0;

   infile.open(filename.c_str());
   if ( !infile.is_open() )
      return -1;
   else {
      while ( !infile.eof() ) {
         line_count++;
         infile.getline(readline, 40, '\n');

         //create new Card object
         Card* new_Card = new Card(readline, line_count);

      #ifdef DEBUG
         cout << new_Card->cardname << endl;
      #endif
         // list is formed latest card read in tacked onto end
         // head is pointer to first card, tail is pointer to last card
         if (this->head == 0) {
            this->head = new_Card;
            this->tail = new_Card;
         } //if
         else {
            this->tail->next = new_Card;
            this->tail = new_Card;
         } //else
      } //while

      if (line_count < 40)
         cout << "WARNING: Deck size less than 40 cards" << endl;
      this->length = line_count;
#ifdef DEBUG
      cout << "cards read: " << line_count << endl;
#endif
   } //else on file open

   return 0;
}  //function ReadRawDeck

Card* CardList::ShuffleList(Card* head_src, long rseed, int length, Card* tail_dst) {
   int toffset = 0;         // the random card count from head
   int mcount = 0;            // count the number of cards that have been moved
   int i = 0;               // index counter to count up to offset
   Card* index, * indexp;
   Card* head_dst = 0;         // this is the head of the list to return

   tail_dst = 0;
   srand(rseed);

   // run through this loop until all cards moved out
   while (mcount < length) {
      toffset = rand() % (length - mcount);
#ifdef DEBUG
      cout << "toffset: " << toffset << endl;
#endif
      index = head_src;        // reset index to head of card list
      indexp = head_src;
      // this loop runs through the card list
      for (i = 0; i < toffset; i++) {
         // keep advancing index as long as cards remain and we haven't hit target
         if (index->next !=0) {
            indexp = index;
            index = index->next;
         }
      } //for

      // if the target is the head of the list, then move the head pointer up one
      if (index == head_src)
         head_src = head_src->next;

#ifdef DEBUG
      cout << "indexp: " << indexp->cardname << "  " << "index: " << index->cardname << endl;

      cout << "src1" << endl;
      PrintList(head_src);
      cout << "dst1" << endl;
      PrintList(head_dst);
#endif

      // we now have the target and target-1 so move em over
      if (index == head_src)
         head_src = index->next;
      else
         indexp->next = index->next;         // pull out the index middle man
      if (head_dst == 0) {
         head_dst = index;
         tail_dst = index;
      } //if
      else {
         tail_dst->next = index;
         tail_dst = index;
      } //else
      index->next = 0;               // the target is now the tail on the destination list

#ifdef DEBUG
      cout << "src2" << endl;
      PrintList(head_src);
      cout << "dst2"  << endl;
      PrintList(head_dst);
#endif

      Sleep(SLEEPMSECS);
      mcount++;
   } //while

   return head_dst;
} //function Shuffle

void CardList::PrintList(Card* head) {
   Card* current = head;
   while (current != 0) {
      cout << current->cardname << endl;
      current = current->next;
   }
} //function PrintList

// recursive function to start from bottom of linked list and deconstruct each card in it
void CardList::DeleteCards(Card* current) {
   if (current == 0)
      return;
   else if (current->next != 0)
      DeleteCards(current->next);
   delete current;
   return;
} //function DeleteCards
