//============================================================================
// Name        : deck_tester.cpp
// Author      : Tyler Sheffield
// Version     : 1.1
// Copyright   : Tyler Sheffield
// Description : MTG DeckTester in C++, Ansi-style
//============================================================================
//

#include "CardList.h"

int turn = 0;		// 0 for Mishra, 1 for Urza

int main() {
   string deck_name_U, deck_name_M;
   string cmd = "g";
   string mishra = "Mishra", urza = "Urza";
   long rseed;							// deck shuffler time based seed
   time_t time_cap;

   cout << "MTG DeckTester 1.1" << endl << endl;
   const char* check = cmd.c_str();
   printf("wtf %s",check);

   // ask user for, and assign, new decks
   cout << "Mishra's deck: ";
   cin >> deck_name_M;

   CardList* deck_M_raw = new CardList(0);
   if ( !deck_M_raw->ReadRawDeck(deck_name_M)) {
      cout << "  --Deck accepted" << endl;
   }
   else {
      cout << "  --Deck not found" << endl;
      return 0;
   }

   // prepare shuffled version of decks by randomly filling in linked list from raw deck
   CardList* deck_M_sh = new CardList(0);
   rseed = (long) time(&time_cap);
   deck_M_sh->head = deck_M_raw->ShuffleList(deck_M_raw->head, rseed, deck_M_raw->length, deck_M_sh->tail);
   //deck_M_sh->PrintList(deck_M_sh->head);

   cout << "Urza's deck: ";
   cin >> deck_name_U;

   CardList* deck_U_raw = new CardList(1);
   if ( !deck_U_raw->ReadRawDeck(deck_name_U))
      cout << "  --Deck accepted" << endl;
   else {
      cout << "  --Deck not found" << endl;
      return 0;
   }

   // prepare shuffled version of decks by randomly filling in linked list from raw deck
   CardList* deck_U_sh = new CardList(1);
   rseed = (long) time(&time_cap);
   deck_U_sh->head = deck_U_raw->ShuffleList(deck_U_raw->head, rseed, deck_U_raw->length, deck_U_sh->tail);

   // create all other needed Card Lists
   CardList* hand_M = new CardList(0);
   CardList* graveyard_M = new CardList(0);
   CardList* removed_M = new CardList(0);
   CardList* play_M = new CardList(0);

   CardList* hand_U = new CardList(0);
   CardList* graveyard_U = new CardList(0);
   CardList* removed_U = new CardList(0);
   CardList* play_U = new CardList(0);

   // main loop with CLI
   while ( cmd != "q" && cmd != "x") {
      cout << "Your command, Master " << (turn ? mishra : urza) << ": " ;
      getline(cin, cmd);
      switch ( cmd.substr(0,1).c_str() ) {
      case 'b':
         break;
      case 'd':
         break;
      case 'e':
         break;
      case 'f':
         break;
      case 'l':
         break;
      case 'r':
         break;
      case 's':
         break;
      case 't':
         break;
	   default:
	      break;
      } //switch
   } //while

   //cleanup
   delete deck_M_raw;
   delete deck_U_raw;
   delete deck_M_sh;
   delete deck_U_sh;

//	cin >> junk;

   return 0;
}
