/*
 * MCDemo.h
 *
 *  Created on: 18 okt. 2017
 *      Author: glas
 */

#ifndef APP_MCDEMO_H_
#define APP_MCDEMO_H_

#include <machine/intrinsics.h>
#include <stdint.h>

#include "system_tc2x.h"
#include "tc_inc_path.h"
#include "interrupts.h"
#include "ledctl.h"

#ifndef APPKIT_TC297TFT
#warning "This exercise was developed for the TC297TFT Application Kit"
#endif

#define __INLINE static inline __attribute__((__always_inline__))

#define __COMMON_BSS __attribute__((asection(".cmnbss","a=4","f=awB")))
#define __LOCAL0_BSS __attribute__((asection(".c0.bss","a=4","f=awBc0")))
#define __LOCAL1_BSS __attribute__((asection(".c1.bss","a=4","f=awBc1")))
#define __LOCAL2_BSS __attribute__((asection(".c2.bss","a=4","f=awBc2"))) 

typedef enum { STM0, STM1, STM2 } STM_t;

#include TC_INCLUDE(TCPATH/IfxCpu_reg.h)
#include TC_INCLUDE(TCPATH/IfxStm_reg.h)
#include TC_INCLUDE(TCPATH/IfxCpu_bf.h)
#include TC_INCLUDE(TCPATH/IfxStm_bf.h)

extern void InstallSTMInterrupt(STM_t,unsigned,int,volatile int *);
extern void STM0ReloadHandler(int);
extern void STM1ReloadHandler(int);
extern void STM2ReloadHandler(int);

extern int init_applproc0(int,char**);
extern int init_applproc1(int,char**);
extern int init_applproc2(int,char**);

extern void Start_Core(unsigned int);

extern int core0_main(void);
extern int core1_main(void);
extern int core2_main(void);

extern int main(void);

#define FOREVER (1)

#define CORE0_READY (1)
#define CORE1_READY (2)
#define CORE2_READY (4)

#define ALL_CORES_READY (7)

__INLINE uint32_t GetCoreID(void)
{
	return _mfcr(CPU_CORE_ID) & IFX_CPU_CORE_ID_CORE_ID_MSK;
}

__INLINE uint32_t __swapmsk(volatile uint32_t * address, uint32_t mask)
{
	uint64_t result = (((uint64_t)mask)<<32)|mask;
	__asm__ volatile
	(
			"swapmsk.w [%1]0,%A0"
			: "+d"(result)
			: "a"(address)
			: "memory"
	);
	return result;
}

__INLINE void main_init(int argc, char **argv)
{
  (void)argc;
  (void)argv;
  SYSTEM_Init();
  SYSTEM_DisableProtection();
  _mtcr(CPU_PCON0, 0);		  /* enable code cache */
  _mtcr(CPU_DCON0, 0);		  /* enable data cache */
  _mtcr(CPU_PMA0, 0x3E0);		/* allow data caching for global CPUn memories */
  _mtcr(CPU_PMA1, 0x3E0);		/* allow code caching for global CPUn memories */
  SYSTEM_EnableProtection();
}

#endif /* APP_MCDEMO_H_ */
