/*====================================================================
* Project:  Board Support Package (BSP)
* Function: macros for handling different AURIX TC29x devices and boards
*
* Copyright HighTec EDV-Systeme GmbH 1982-2016
*====================================================================*/

#ifndef __TC_INC_PATH_H__
#define __TC_INC_PATH_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#if defined(__TC29XX__)
# if defined(TRIBOARD_TC29XX)
#  define TCPATH	tc29xx
# elif defined(TRIBOARD_TC29XA)
#  define TCPATH	tc29xa
# elif defined(TRIBOARD_TC29XB) || defined(APPKIT_TC297TFT)
#  define TCPATH	tc29xb
# else
#  error "Unknown TC29x board"
# endif /* TRIBOARD_TC29XX */
#else
# error "Unsupported AURIX device"
#endif /* __TC29XX__ */

#define TC_STR(s)		# s
#define TC_INCLUDE(f)	TC_STR(f)

/* check for application kits */
#define APPKIT_TC2X5	0

#if defined(APPKIT_TC297TFT)
# define APPKIT_TC2X7	1
#else
# define APPKIT_TC2X7	0
#endif /* APPKIT_TC2X7 */
#if (APPKIT_TC2X7 > 0) || (APPKIT_TC2X5 > 0)
# define RUN_ON_APPKIT	1
#else
# define RUN_ON_APPKIT	0
#endif /* APPKIT_TC2XX */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __TC_INC_PATH_H__ */
