/*
 * tricoreIROM.x -- TriBoard-TC29xx full linker script
 *   (using internal Flash for code and internal RAM for data)
 *
 * Copyright (C) 1982-2015 HighTec EDV-Systeme GmbH.
 */

OUTPUT_FORMAT("elf32-tricore")
OUTPUT_ARCH(tricore)
ENTRY(_start)

__TRICORE_DERIVATE_MEMORY_MAP__ = 0x2900;

 /* the symbol __TRICORE_DERIVATE_NAME__ will be defined in the crt0_tc29x.c and is
  * tested here to confirm that this memory map and the startup file will fit together
  */
  _. = ASSERT ((__TRICORE_DERIVATE_MEMORY_MAP__ == __TRICORE_DERIVATE_NAME__), "Using wrong Memory Map. This Map is for TC29XX");

/* minimal heap size (C library stuff) */
__HEAP_SIZE = DEFINED (__HEAP_SIZE) ? __HEAP_SIZE : 16K;

MEMORY
{
/* internal flash memories */
  int_flash0 (rx): org = 0x80000000, len = 2M
  int_flash1 (rx): org = 0x80200000, len = 2M
  int_flash2 (rx): org = 0x80400000, len = 2M
  int_flash3 (rx): org = 0x80600000, len = 2M

/* ED (emulation device) memory */
  ed_mem (rx):  org = 0x9f000000, len = 1M

/* internal code ram */
  int_psprcpu0 (rxc0): org = 0xc0000000, len = 32K
  int_psprcpu1 (rxc1): org = 0xc0000000, len = 32K
  int_psprcpu2 (rxc2): org = 0xc0000000, len = 32K

/* internal data ram */
  int_dsprcpu0 (wc0!x): org = 0xd0000000, len = 120K
  int_dsprcpu1 (wc1!x): org = 0xd0000000, len = 240K
  int_dsprcpu2 (wc2!x): org = 0xd0000000, len = 240K

/* global view on internal memories */
  glb_int_psprcpu0 (rx): org = 0x70100000, len = 32K
  glb_int_psprcpu1 (rx): org = 0x60100000, len = 32K
  glb_int_psprcpu2 (rx): org = 0x50100000, len = 32K
  glb_int_dsprcpu0 (w!x): org = 0x70000000, len = 120K
  glb_int_dsprcpu1 (w!x): org = 0x60000000, len = 240K
  glb_int_dsprcpu2 (w!x): org = 0x50000000, len = 240K

/* global LMU RAM */
/* using the non cachable address enable shared accesses */
  lmu_sram (wx): org = 0xB0000000, len = 32K

/* local view on GTM/MCS data and code memory */
  int_mcs0_code (rx): org = 0x0000, len = 4K
  int_mcs0_data (w):  org = 0x1000, len = 2K

/* TriCore view on GTM/MCS data and code memory */
  glb_mcs0_code (rx): org = 0xf0138000, len = 4K
  glb_mcs0_data (w):  org = 0xf0139000, len = 2K
}

/* Use alias for memory regions */
REGION_ALIAS("MCS0_TEXT", glb_mcs0_code)
REGION_ALIAS("MCS0_DATA", glb_mcs0_data)

REGION_ALIAS("CODE_MEM", int_flash0)
REGION_ALIAS("FASTCODE_MEM", int_psprcpu0)
REGION_ALIAS("FASTCODE_MEM_CPU0_", int_psprcpu0)
REGION_ALIAS("FASTCODE_MEM_CPU1_", int_psprcpu1)
REGION_ALIAS("FASTCODE_MEM_CPU2_", int_psprcpu2)

REGION_ALIAS("RODATA_MEM", int_flash0)
REGION_ALIAS("GLOB_DATA", lmu_sram)

REGION_ALIAS("CSA_CPU0_", int_dsprcpu0)
REGION_ALIAS("DATA_CPU0_", int_dsprcpu0)
REGION_ALIAS("SDATA_CPU0_", int_dsprcpu0)
REGION_ALIAS("ZDATA_CPU0_", int_dsprcpu0)
REGION_ALIAS("BSS_CPU0_", int_dsprcpu0)

REGION_ALIAS("CSA_CPU1_", int_dsprcpu1)
REGION_ALIAS("DATA_CPU1_", int_dsprcpu1)
REGION_ALIAS("SDATA_CPU1_", int_dsprcpu1)
REGION_ALIAS("ZDATA_CPU1_", int_dsprcpu1)
REGION_ALIAS("BSS_CPU1_", int_dsprcpu1)

REGION_ALIAS("CSA_CPU2_", int_dsprcpu2)
REGION_ALIAS("DATA_CPU2_", int_dsprcpu2)
REGION_ALIAS("SDATA_CPU2_", int_dsprcpu2)
REGION_ALIAS("ZDATA_CPU2_", int_dsprcpu2)
REGION_ALIAS("BSS_CPU2_", int_dsprcpu2)

/* Include section description */
INCLUDE tricoreSections.lsf
