/*
 * stm.c
 *
 *  Created on: 28 okt. 2017
 *      Author: glas
 */

#include "MCDemo.h"

static volatile int * pt0;
static volatile int * pt1;
static volatile int * pt2;

_Pragma("GCC diagnostic push")
_Pragma("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")

void InstallSTMInterrupt(STM_t stmID, unsigned reloadHz, int prio, volatile int * toggle)
{
  unsigned reload = SYSTEM_GetStmClock()/reloadHz;
  Ifx_STM * stm;
  int irqNum;

  switch (stmID)
  {
    case STM0:  stm = (Ifx_STM *)&MODULE_STM0;
                irqNum = SRC_ID_STM0SR0;
                pt0 = toggle;
                InterruptInstall(irqNum,STM0ReloadHandler,prio,reload);
                break;
    case STM1:  stm = (Ifx_STM *)&MODULE_STM1;
                irqNum = SRC_ID_STM1SR0;
                pt1 = toggle;
                InterruptInstall(irqNum,STM1ReloadHandler,prio,reload);
                break;
    case STM2:  stm = (Ifx_STM *)&MODULE_STM2;
                irqNum = SRC_ID_STM2SR0;
                pt2 = toggle;
                InterruptInstall(irqNum,STM2ReloadHandler,prio,reload);
                break;
  }

  /* reset interrupt flag */
  stm->ISCR.U = (IFX_STM_ISCR_CMP0IRR_MSK << IFX_STM_ISCR_CMP0IRR_OFF);
  /* prepare compare register */
  stm->CMP[0].U = stm->TIM0.U + reload;
  stm->CMCON.B.MSIZE0 = 31;
  stm->ICR.B.CMP0EN = 1;
}

_Pragma("GCC diagnostic pop")

void STM0ReloadHandler(int reload)
{
  Ifx_STM * stm = (Ifx_STM *)&MODULE_STM0;
  stm->CMP[0].U += (unsigned) reload;
  *pt0 = 1;
}

void STM1ReloadHandler(int reload)
{
  Ifx_STM * stm = (Ifx_STM *)&MODULE_STM1;
  stm->CMP[0].U += (unsigned) reload;
  *pt1 = 1;
}

void STM2ReloadHandler(int reload)
{
  Ifx_STM * stm = (Ifx_STM *)&MODULE_STM2;
  stm->CMP[0].U += (unsigned) reload;
  *pt2 = 1;
}
